/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.directory.ApacheDS;
import com.atlassian.crowd.directory.ApacheDS15;
import com.atlassian.crowd.directory.AppleOpenDirectory;
import com.atlassian.crowd.directory.FedoraDS;
import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.NovelleDirectory;
import com.atlassian.crowd.directory.OpenDS;
import com.atlassian.crowd.directory.OpenLDAP;
import com.atlassian.crowd.directory.OpenLDAPRfc2307;
import com.atlassian.crowd.directory.Rfc2307;
import com.atlassian.crowd.directory.SunONE;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapErrorDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum LdapType {
    LDAP("\\[LDAP:\\s+[^\\d]+([\\d]+)\\s+-\\s+([^]]+)\\].*"),
    AD("\\[LDAP:\\s+error code ([\\d]+)\\s+.*, data ([\\da-z]+),.*\\]", "healthcheck.directory.ldap.authentication.error.");

    private static final Map<String, LdapType> IMPL_CLASS_TO_TYPES;
    private final Pattern regex;
    private final String messageCodePrefix;

    private LdapType(String regex) {
        this(regex, "");
    }

    private LdapType(String regex, String messageCodePrefix) {
        this.regex = Pattern.compile(regex);
        this.messageCodePrefix = messageCodePrefix;
    }

    public static Optional<LdapType> fromImplClass(String implClass) {
        return IMPL_CLASS_TO_TYPES.containsKey(implClass) ? Optional.of(IMPL_CLASS_TO_TYPES.get(implClass)) : Optional.empty();
    }

    public Set<String> getImplClasses() {
        return IMPL_CLASS_TO_TYPES.entrySet().stream().filter(entry -> entry.getValue() == this).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Optional<LdapErrorDetails> parseErrorMessage(String errorMessage) {
        Matcher matcher = this.regex.matcher(errorMessage);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return Optional.of(this.createLdapErrorDetails(matcher.group(1), matcher.group(2)));
        }
        return Optional.empty();
    }

    private LdapErrorDetails createLdapErrorDetails(String code, String messageCode) {
        return new LdapErrorDetails(this.messageCodePrefix + messageCode, messageCode, code);
    }

    static {
        IMPL_CLASS_TO_TYPES = ImmutableMap.builder().put((Object)MicrosoftActiveDirectory.class.getName(), (Object)AD).put((Object)ApacheDS.class.getName(), (Object)LDAP).put((Object)ApacheDS15.class.getName(), (Object)LDAP).put((Object)AppleOpenDirectory.class.getName(), (Object)LDAP).put((Object)FedoraDS.class.getName(), (Object)LDAP).put((Object)GenericLDAP.class.getName(), (Object)LDAP).put((Object)NovelleDirectory.class.getName(), (Object)LDAP).put((Object)OpenDS.class.getName(), (Object)LDAP).put((Object)OpenLDAP.class.getName(), (Object)LDAP).put((Object)OpenLDAPRfc2307.class.getName(), (Object)LDAP).put((Object)Rfc2307.class.getName(), (Object)LDAP).put((Object)SunONE.class.getName(), (Object)LDAP).build();
    }
}

