/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.ihs;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.stp.action.AbstractSupportToolsAction;
import com.atlassian.troubleshooting.stp.action.SupportToolsAction;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class InstanceHealthScoreAction
extends AbstractSupportToolsAction {
    public static final String IHS_FEATURE_KEY = "com.atlassian.troubleshooting.ihs.disabled";
    public static final String ACTION_NAME = "instance-health-score";
    private static final List<ApplicationType> SUPPORTED_APPS = ImmutableList.of((Object)((Object)ApplicationType.JIRA));
    private final SupportApplicationInfo applicationInfo;
    private final DarkFeatureManager darkFeatureManager;

    public InstanceHealthScoreAction(SupportApplicationInfo applicationInfo, DarkFeatureManager darkFeatureManager) {
        super(ACTION_NAME, "stp.troubleshooting.title", "stp.ihs.tab.title", null);
        this.applicationInfo = applicationInfo;
        this.darkFeatureManager = darkFeatureManager;
    }

    public static boolean isAvailable(ApplicationType applicationType) {
        return SUPPORTED_APPS.contains((Object)applicationType);
    }

    @Override
    public boolean isEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(IHS_FEATURE_KEY).orElse(false) == false;
    }

    @Override
    @Nonnull
    public SupportToolsAction newInstance() {
        return new InstanceHealthScoreAction(this.applicationInfo, this.darkFeatureManager);
    }
}

