/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.jfr.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.troubleshooting.jfr.manager.JfrRecordingManager;
import com.atlassian.troubleshooting.stp.security.PermissionValidationService;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/jfr/recordings")
@Produces(value={"application/json"})
@Singleton
@WebSudoRequired
public class JfrRecordingResource {
    private final PermissionValidationService permissionValidationService;
    private final JfrRecordingManager jfrRecordingManager;

    @Inject
    public JfrRecordingResource(PermissionValidationService permissionValidationService, JfrRecordingManager jfrRecordingManager) {
        this.permissionValidationService = Objects.requireNonNull(permissionValidationService);
        this.jfrRecordingManager = Objects.requireNonNull(jfrRecordingManager);
    }

    @ExperimentalApi
    @GET
    public Response getRecordings() {
        this.permissionValidationService.validateIsSysadmin();
        return Response.ok(this.jfrRecordingManager.getRecordingDetails()).build();
    }
}

