/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.persistence;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitCheckType;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseUserLimitConfigurationStore {
    @VisibleForTesting
    public static final String KEY_TEMPLATE = "com.atlassian.troubleshooting.healthcheck.licenseuserlimit.%s";
    @VisibleForTesting
    public static final LicenseUserLimitConfiguration DEFAULT_CONFIGURATION = new LicenseUserLimitConfiguration(10, true);
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUserLimitConfigurationStore.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public LicenseUserLimitConfigurationStore(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void storeConfiguration(LicenseUserLimitCheckType checkType, @Nonnull LicenseUserLimitConfiguration configuration) {
        try {
            String configurationJson = this.objectMapper.writeValueAsString((Object)configuration);
            this.pluginSettingsFactory.createGlobalSettings().put(this.getConfigKey(checkType), (Object)configurationJson);
        }
        catch (IOException e) {
            LOG.error(String.format("Couldn't persist %s license user limit configuration with key '%s'", new Object[]{checkType, this.getConfigKey(checkType)}), (Throwable)e);
        }
    }

    public LicenseUserLimitConfiguration getConfiguration(LicenseUserLimitCheckType checkType) {
        Object storedConfigObject = this.pluginSettingsFactory.createGlobalSettings().get(this.getConfigKey(checkType));
        if (storedConfigObject == null) {
            return DEFAULT_CONFIGURATION;
        }
        try {
            return (LicenseUserLimitConfiguration)this.objectMapper.readValue((String)storedConfigObject, LicenseUserLimitConfiguration.class);
        }
        catch (IOException e) {
            LOG.error(String.format("Couldn't read %s license user limit configuration key '%s'", new Object[]{checkType, this.getConfigKey(checkType)}), (Throwable)e);
            return DEFAULT_CONFIGURATION;
        }
    }

    private String getConfigKey(LicenseUserLimitCheckType checkType) {
        return String.format(KEY_TEMPLATE, checkType.getKey());
    }
}

