/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.cluster;

import com.atlassian.troubleshooting.cluster.JsonSerialiser;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultJsonSerialiser
implements JsonSerialiser {
    final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + json + " from JSON", e);
        }
    }

    @Override
    public String toJson(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing " + String.valueOf(o) + " to JSON", e);
        }
    }
}

