/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.LicenseService;
import com.atlassian.troubleshooting.stp.cluster.NoopClusterService;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class BambooClusterServiceProvider {
    private BambooClusterServiceProvider() {
    }

    public static boolean serverIsCapableOfProducingClusteringInfo(@NotNull ApplicationProperties applicationProperties) {
        try {
            return Integer.parseInt(applicationProperties.getBuildNumber()) >= 80010;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static ClusterService createBambooClusterService(@NotNull ApplicationProperties applicationProperties, @NotNull LicenseService licenseService) {
        if (BambooClusterServiceProvider.serverIsCapableOfProducingClusteringInfo(applicationProperties)) {
            try {
                Class<?> clazz = Class.forName("com.atlassian.troubleshooting.bamboo.BambooClusterService");
                Constructor<?> constructor = clazz.getConstructor(LicenseService.class);
                return (ClusterService)constructor.newInstance(licenseService);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new NoopClusterService();
    }
}

