/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base64ObjectSerializerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64ObjectSerializerUtil.class);

    private Base64ObjectSerializerUtil() {
    }

    public static <T extends Serializable> Optional<T> deserialize(String serialized) {
        Optional<Serializable> optional;
        byte[] data = Base64.getDecoder().decode(serialized);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            Object o = ois.readObject();
            optional = Optional.of((Serializable)o);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to deserialize task monitor", (Throwable)e);
                return Optional.empty();
            }
        }
        ois.close();
        return optional;
    }

    public static <T extends Serializable> Optional<T> safeDeserialize(Class<?> type, List<Class<?>> safeClasses, String obj) {
        Optional<Serializable> optional;
        SafeObjectInputStream ois = new SafeObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(obj)), type, safeClasses);
        try {
            optional = Optional.of((Serializable)ois.readObject());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to deserialize task monitor", (Throwable)e);
                return Optional.empty();
            }
        }
        ois.close();
        return optional;
    }

    public static <T extends Serializable> Optional<T> safeDeserialize(Class<?> type, String obj) {
        return Base64ObjectSerializerUtil.safeDeserialize(type, Collections.emptyList(), obj);
    }

    public static <T extends Serializable> String serialize(T object) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            string = Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to serialize task monitor", (Throwable)e);
                return "";
            }
        }
        baos.close();
        return string;
    }

    private static class SafeObjectInputStream
    extends ObjectInputStream {
        private static final List<Class<?>> DEFAULT_SAFE_CLASSES = Arrays.asList(String.class, Boolean.class, Integer.class, Long.class, Double.class, Float.class, Byte.class, Short.class, Number.class, ArrayList.class, LinkedList.class, HashMap.class, LinkedHashMap.class);
        private final Class<?> castType;
        private final List<Class<?>> passedSafeClasses;

        public SafeObjectInputStream(InputStream in, Class<?> castType, List<Class<?>> passedSafeClasses) throws IOException {
            super(in);
            this.castType = castType;
            this.passedSafeClasses = passedSafeClasses;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
            Class<?> clazz = super.resolveClass(osc);
            if (clazz.equals(this.castType) || DEFAULT_SAFE_CLASSES.contains(clazz) || this.passedSafeClasses.contains(clazz)) {
                return clazz;
            }
            throw new SecurityException("Can't deserialize unsafe class " + clazz);
        }
    }
}

