/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.util;

public class LicenseUsageUtil {
    private LicenseUsageUtil() {
        throw new UnsupportedOperationException("This is a utility class");
    }

    public static boolean isThresholdPassed(int numberOfTakenSeats, int numberOfSeats, Threshold remainingThreshold) {
        float remainingSeatsThreshold = remainingThreshold.isPercentage() ? (float)(numberOfSeats * remainingThreshold.getValue()) / 100.0f : (float)remainingThreshold.getValue();
        return (float)(numberOfSeats - numberOfTakenSeats) < remainingSeatsThreshold;
    }

    public static class Threshold {
        private final int value;
        private final boolean percentage;

        private Threshold(int value, boolean isPercentage) {
            if (value < 0) {
                throw new IllegalArgumentException("Threshold value can not be negative");
            }
            this.value = value;
            this.percentage = isPercentage;
        }

        public static Threshold ofValue(int value) {
            return new Threshold(value, false);
        }

        public static Threshold ofPercentage(int percentage) {
            if (percentage > 100) {
                throw new IllegalArgumentException("Threshold value must be less than or equal to 100 if it is percentage");
            }
            return new Threshold(percentage, true);
        }

        public int getValue() {
            return this.value;
        }

        public boolean isPercentage() {
            return this.percentage;
        }

        public String toString() {
            return "Threshold{threshold=" + this.value + ", percentage=" + this.percentage + "}";
        }
    }
}

