/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.DefaultHelpPath;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.Application;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AtstHelpPathResolver
implements HelpPathResolver {
    private final I18nResolver i18nResolver;
    private final HelpPathResolver delegate;
    private final Application application;

    public AtstHelpPathResolver(@Nonnull I18nResolver i18nResolver, @Nonnull HelpPathResolver delegate, @Nonnull ApplicationProperties applicationProperties) {
        this.i18nResolver = Objects.requireNonNull(i18nResolver);
        this.delegate = Objects.requireNonNull(delegate);
        ApplicationProperties appProperties = Objects.requireNonNull(applicationProperties);
        this.application = Application.byAppDisplayName(appProperties.getDisplayName());
    }

    public HelpPath getHelpPath(String key) {
        return this.application.equals((Object)Application.Bamboo) ? this.resolveBambooHelpPath(key) : this.delegate.getHelpPath(key);
    }

    private HelpPath resolveBambooHelpPath(String hcHelpUrlKey) {
        String hcHelpUrl = this.getI18nMessage(hcHelpUrlKey);
        if (hcHelpUrl.startsWith("https://")) {
            return new DefaultHelpPath(hcHelpUrlKey, hcHelpUrl, null, null, false);
        }
        return this.delegate.getHelpPath(hcHelpUrlKey);
    }

    private String getI18nMessage(String key) {
        return this.i18nResolver.getText(key);
    }
}

