/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.security.InputManipulationException;

public class SecurityUtils {
    public static void checkForCollectionDoSAttack(UnmarshallingContext context, long start) {
        Integer secondsUsed;
        int diff = (int)((System.currentTimeMillis() - start) / 1000L);
        if (diff > 0 && (secondsUsed = (Integer)context.get("XStreamCollectionUpdateSeconds")) != null) {
            Integer limit = (Integer)context.get("XStreamCollectionUpdateLimit");
            if (limit == null) {
                throw new ConversionException("Missing limit for updating collections.");
            }
            int seconds = secondsUsed + diff;
            if (seconds > limit) {
                throw new InputManipulationException("Denial of Service attack assumed. Adding elements to collections or maps exceeds " + limit + " seconds.");
            }
            context.put("XStreamCollectionUpdateSeconds", new Integer(seconds));
        }
    }

    public static void checkDepthLimit(UnmarshallingContext context, HierarchicalStreamReader reader) {
        Integer maxAllowedDepth = (Integer)context.get("XStreamMaxAllowedDepth");
        if (maxAllowedDepth != null && reader.getLevel() > maxAllowedDepth) {
            throw new XStreamException("XML depth exceeds maximum allowed depth of " + maxAllowedDepth);
        }
    }

    public static void checkFieldLimit(UnmarshallingContext context, int fieldsLength) {
        Integer maxAllowedFields = (Integer)context.get("XStreamMaxAllowedFields");
        if (maxAllowedFields != null && fieldsLength > maxAllowedFields) {
            throw new XStreamException("Encountered more fields than the maximum allowed size of " + maxAllowedFields);
        }
    }

    public static void checkFieldValueLimit(UnmarshallingContext context, String value) {
        Integer maxAllowedValue = (Integer)context.get("XStreamMaxAllowedValue");
        if (maxAllowedValue != null && value.length() > maxAllowedValue) {
            throw new XStreamException("Size of value longer than the maximum allowed size of " + maxAllowedValue);
        }
    }
}

