/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.impl.MessageSet;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDirectoryHealthCheck
implements SupportHealthCheck {
    protected final SupportHealthStatusBuilder supportHealthStatusBuilder;
    protected final CrowdDirectoryService crowdDirectoryService;

    protected AbstractDirectoryHealthCheck(SupportHealthStatusBuilder supportHealthStatusBuilder, CrowdDirectoryService crowdDirectoryService) {
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public SupportHealthStatus check() {
        List<Directory> directories = this.getDirectories();
        if (directories.isEmpty()) {
            return this.supportHealthStatusBuilder.ok(this, this.getNoDirsKeyMessage(), new Serializable[0]);
        }
        MessageSet messageSet = new MessageSet();
        directories.forEach(directory -> this.checkDirectory(messageSet, (Directory)directory));
        if (messageSet.hasAnyErrors()) {
            return this.supportHealthStatusBuilder.major(this, this.getCredentialsFailKeyMessage(), new Serializable[]{StringUtils.join(messageSet.getErrorMessages(), (String)", ")});
        }
        if (messageSet.hasAnyWarnings()) {
            return this.supportHealthStatusBuilder.major(this, this.getConnectFailKeyMessage(), new Serializable[]{StringUtils.join(messageSet.getWarningMessages(), (String)", ")});
        }
        return this.supportHealthStatusBuilder.ok(this, this.getOkKeyMessage(), new Serializable[0]);
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    private List<Directory> getDirectories() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(this::isDirectorySupported).collect(Collectors.toList());
    }

    public abstract boolean isDirectorySupported(Directory var1);

    protected abstract void checkDirectory(MessageSet var1, Directory var2);

    protected abstract String getCredentialsFailKeyMessage();

    protected abstract String getConnectFailKeyMessage();

    protected abstract String getNoDirsKeyMessage();

    protected abstract String getOkKeyMessage();
}

