/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.jfr;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.jfr.config.JfrServiceProductSupport;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooJfrServiceProductSupport
implements JfrServiceProductSupport {
    private static final int JFR_ACTIVATION_BUILD = 90601;
    private static final int JFR_RUNNING_BY_DEFAULT_BUILD = 90602;
    private final DarkFeatureManager darkFeatureManager;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public BambooJfrServiceProductSupport(DarkFeatureManager darkFeatureManager, ApplicationProperties applicationProperties) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
    }

    @Override
    public boolean isSupported() {
        boolean disabledExplicit = this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.troubleshooting.jfr.disabled").orElse(false);
        if (disabledExplicit) {
            return false;
        }
        boolean enabledExplicit = this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.troubleshooting.jfr.enabled").orElse(false);
        if (enabledExplicit) {
            return true;
        }
        return this.isActivatedByDefault();
    }

    private boolean isActivatedByDefault() {
        return Long.parseLong(this.applicationProperties.getBuildNumber()) >= 90601L;
    }

    @Override
    public boolean isRunningByDefault() {
        return Long.parseLong(this.applicationProperties.getBuildNumber()) >= 90602L;
    }
}

