/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="healthcheck.configuration.licenseUserLimit")
public final class LicenseUserLimitConfigUpdateEvent {
    private final int limit;
    private final boolean isPercentage;
    private final LicenseUserLimitConfigurationStore.Product product;

    private LicenseUserLimitConfigUpdateEvent(int limit, boolean isPercentage, LicenseUserLimitConfigurationStore.Product product) {
        this.limit = limit;
        this.isPercentage = isPercentage;
        this.product = product;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean getIsPercentage() {
        return this.isPercentage;
    }

    public LicenseUserLimitConfigurationStore.Product getProduct() {
        return this.product;
    }

    public static LicenseUserLimitConfigUpdateEvent of(LicenseUserLimitConfiguration config, LicenseUserLimitConfigurationStore.Product product) {
        Objects.requireNonNull(config, "config cannot be null");
        Objects.requireNonNull(product, "product cannot be null");
        return new LicenseUserLimitConfigUpdateEvent(config.getLimit(), config.getIsPercentage(), product);
    }
}

