/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.troubleshooting.healthcheck.event.AbstractLicenseUserLimitHealthCheckEvent;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import java.util.Objects;

@EventName(value="healthcheck.licenseUserLimit.jira")
public class JiraLicenseUserLimitHealthCheckEvent
extends AbstractLicenseUserLimitHealthCheckEvent {
    private final boolean isApplicationRoleLimitExceeded;
    private final boolean isAnyRoleLimitExceeded;
    private final LicenseUserLimitConfigurationStore.Product product;

    private JiraLicenseUserLimitHealthCheckEvent(Boolean isApplicationRoleLimitExceeded, Boolean isAnyRoleLimitExceeded, Integer licenseSeatLimit, LicenseUserLimitConfigurationStore.Product product, Integer seatsUsed) {
        super(licenseSeatLimit, seatsUsed);
        this.isApplicationRoleLimitExceeded = Objects.requireNonNull(isApplicationRoleLimitExceeded, "applicationRoleLimitExceeded cannot be null");
        this.isAnyRoleLimitExceeded = Objects.requireNonNull(isAnyRoleLimitExceeded, "anyRoleLimitExceeded cannot be null");
        this.product = Objects.requireNonNull(product, "product cannot be null");
    }

    public boolean getIsApplicationRoleLimitExceeded() {
        return this.isApplicationRoleLimitExceeded;
    }

    public boolean getIsAnyRoleLimitExceeded() {
        return this.isAnyRoleLimitExceeded;
    }

    public LicenseUserLimitConfigurationStore.Product getProduct() {
        return this.product;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractLicenseUserLimitHealthCheckEvent.Builder<Builder> {
        private Boolean isApplicationRoleLimitExceeded;
        private Boolean isAnyRoleLimitExceeded;
        private LicenseUserLimitConfigurationStore.Product product;

        public Builder isApplicationRoleLimitExceeded(Boolean isApplicationRoleLimitExceeded) {
            this.isApplicationRoleLimitExceeded = isApplicationRoleLimitExceeded;
            return this.self();
        }

        public Builder isAnyRoleLimitExceeded(Boolean isAnyRoleLimitExceeded) {
            this.isAnyRoleLimitExceeded = isAnyRoleLimitExceeded;
            return this.self();
        }

        public Builder product(LicenseUserLimitConfigurationStore.Product product) {
            this.product = product;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JiraLicenseUserLimitHealthCheckEvent build() {
            return new JiraLicenseUserLimitHealthCheckEvent(this.isApplicationRoleLimitExceeded, this.isAnyRoleLimitExceeded, this.licenseSeatLimit, this.product, this.seatsUsed);
        }
    }
}

