/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support.database.mysql;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.bamboo.health.MySQLChecks;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxAllowedPacketSizeCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MaxAllowedPacketSizeCheck.class);
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder healthStatusBuilder;

    public MaxAllowedPacketSizeCheck(BambooHealthCheckService bambooHealthCheckService, SupportHealthStatusBuilder healthStatusBuilder) {
        this.bambooHealthCheckService = bambooHealthCheckService;
        this.healthStatusBuilder = healthStatusBuilder;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        MySQLChecks mySQLChecks = this.bambooHealthCheckService.getMySQLChecks();
        try {
            if (mySQLChecks.isMaxAllowedPacketSizeCheckPass()) {
                return this.healthStatusBuilder.ok(this, "bamboo.healthcheck.mysql.max.packet.valid", new Serializable[0]);
            }
            return this.healthStatusBuilder.warning(this, "bamboo.healthcheck.mysql.max.packet.fail", new Serializable[]{FileUtils.byteCountToDisplaySize(mySQLChecks.getMaxAllowedPacketSize()), FileUtils.byteCountToDisplaySize(mySQLChecks.getRecommendedMaxPacketsSize())});
        }
        catch (IllegalStateException e) {
            LOG.info("Exception caught during Max Allowed packet check", (Throwable)e);
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.database.query.no.results", new Serializable[0]);
        }
    }
}

