/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.k8s;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class HelmValuesFileCondition
implements Condition {
    public static final String DEFAULT_HELM_VALUES_FILE_PATH = "/opt/atlassian/helm/values.yaml";
    public static final String HELM_VALUES_FILE_PATH_PROPERTY = "helm.values.file.path";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return Files.exists(Paths.get(HelmValuesFileCondition.getHelmValueFilePath(), new String[0]), new LinkOption[0]);
    }

    public static String getHelmValueFilePath() {
        String customPath = System.getProperty(HELM_VALUES_FILE_PATH_PROPERTY, DEFAULT_HELM_VALUES_FILE_PATH);
        if (customPath != null && !customPath.isEmpty()) {
            return customPath;
        }
        return DEFAULT_HELM_VALUES_FILE_PATH;
    }
}

