/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support.database.mysql;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.bamboo.health.MySQLChecks;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnoDBLogFileSizeCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(InnoDBLogFileSizeCheck.class);
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder healthStatusBuilder;

    public InnoDBLogFileSizeCheck(BambooHealthCheckService bambooHealthCheckService, SupportHealthStatusBuilder healthStatusBuilder) {
        this.bambooHealthCheckService = bambooHealthCheckService;
        this.healthStatusBuilder = healthStatusBuilder;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        MySQLChecks mySQLChecks = this.bambooHealthCheckService.getMySQLChecks();
        try {
            if (mySQLChecks.isInnoDBLogFileSizeCheckPass()) {
                return this.healthStatusBuilder.ok(this, "bamboo.healthcheck.mysql.innodb.log.file.size.valid", new Serializable[0]);
            }
            long innoDBLogFileSize = mySQLChecks.getInnoDBLogFileSize();
            long recommendedInnoDBLogFileSize = mySQLChecks.getRecommendedInnoDBLogFileSize();
            return this.healthStatusBuilder.warning(this, "bamboo.healthcheck.mysql.innodb.log.file.size.fail", new Serializable[]{FileUtils.byteCountToDisplaySize(innoDBLogFileSize), FileUtils.byteCountToDisplaySize(recommendedInnoDBLogFileSize)});
        }
        catch (IllegalStateException e) {
            LOG.info("Exception caught during InnoDB check", (Throwable)e);
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.database.query.no.results", new Serializable[0]);
        }
    }
}

