/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckCondition;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LdapConfiguredCondition
implements SupportHealthCheckCondition {
    private static final Set<LdapType> SUPPORTED_LDAP_TYPES = new HashSet<LdapType>(Arrays.asList(LdapType.AD, LdapType.LDAP));
    private static final Set<DirectoryType> SUPPORTED_DIR_TYPES = new HashSet<DirectoryType>(Arrays.asList(DirectoryType.CONNECTOR, DirectoryType.DELEGATING));
    private final CrowdDirectoryService crowdDirectoryService;

    public LdapConfiguredCondition(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    static boolean isDirectorySupported(Directory directory) {
        return directory.isActive() && SUPPORTED_DIR_TYPES.contains(directory.getType()) && SUPPORTED_LDAP_TYPES.contains(LdapType.fromImplClass(directory.getImplementationClass()).orElse(null));
    }

    @Override
    public boolean shouldDisplay() {
        return this.crowdDirectoryService.findAllDirectories().stream().anyMatch(LdapConfiguredCondition::isDirectorySupported);
    }
}

