/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.service;

import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import java.util.Objects;

public abstract class AbstractLicenseUserLimitService
implements LicenseUserLimitService {
    private final LicenseUserLimitConfigurationStore licenseUserLimitConfigurationStore;

    protected AbstractLicenseUserLimitService(LicenseUserLimitConfigurationStore licenseUserLimitConfigurationStore) {
        this.licenseUserLimitConfigurationStore = licenseUserLimitConfigurationStore;
    }

    @Override
    public LicenseUserLimitConfiguration getLicenseUserLimitConfig() {
        return this.licenseUserLimitConfigurationStore.getConfiguration(this.getProduct());
    }

    @Override
    public void setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) throws InvalidLicenseUserLimitException {
        Objects.requireNonNull(licenseUserLimitConfiguration, "licenseUserLimitConfiguration cannot be null");
        if (licenseUserLimitConfiguration.getLimit() < 0) {
            throw new InvalidLicenseUserLimitException("License user limit can not be negative");
        }
        if (licenseUserLimitConfiguration.getIsPercentage() && licenseUserLimitConfiguration.getLimit() > 100) {
            throw new InvalidLicenseUserLimitException("License user limit must be less than or equal to 100 if it is percentage");
        }
        this.licenseUserLimitConfigurationStore.storeConfiguration(this.getProduct(), licenseUserLimitConfiguration);
    }

    protected abstract LicenseUserLimitConfigurationStore.Product getProduct();
}

