/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support.database.mysql;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CharacterSetCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CharacterSetCheck.class);
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder healthStatusBuilder;

    public CharacterSetCheck(BambooHealthCheckService bambooHealthCheckService, SupportHealthStatusBuilder healthStatusBuilder) {
        this.bambooHealthCheckService = Objects.requireNonNull(bambooHealthCheckService);
        this.healthStatusBuilder = Objects.requireNonNull(healthStatusBuilder);
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        try {
            if (this.bambooHealthCheckService.getMySQLChecks().isCharacterSetCheckPass()) {
                return this.healthStatusBuilder.ok(this, "bamboo.healthcheck.mysql.character.set.valid", new Serializable[0]);
            }
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.mysql.character.set.fail", new Serializable[0]);
        }
        catch (IllegalStateException e) {
            LOG.info("Exception caught during character set check", (Throwable)e);
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.database.query.no.results", new Serializable[0]);
        }
    }
}

