/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.AbstractBackupHealthCheck;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class BambooBackupHealthCheck
extends AbstractBackupHealthCheck {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public BambooBackupHealthCheck(ClusterService clusterService, SupportHealthStatusBuilder statusBuilder, I18nResolver i18nResolver, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        super(clusterService, statusBuilder, i18nResolver);
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @Override
    protected void checkImpl(List<String> failures) {
        String scheduledBackupDirToCheck;
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        String sharedHomePath = bootstrapManager.getSharedHomePath();
        ScheduleBackupConfiguration scheduleBackupConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getScheduleBackupConfiguration();
        HashSet<String> backupPaths = new HashSet<String>();
        if (scheduleBackupConfiguration != null && (scheduledBackupDirToCheck = scheduleBackupConfiguration.getBackupPath(sharedHomePath)) != null) {
            backupPaths.add(scheduledBackupDirToCheck);
        }
        backupPaths.add(sharedHomePath + File.separator + "backups/");
        backupPaths.add(sharedHomePath + File.separator + "exports/");
        backupPaths.forEach(backupPath -> this.checkDirectory(failures, (String)backupPath));
    }
}

