/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.service;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.troubleshooting.healthcheck.event.LicenseUserLimitConfigUpdateEvent;
import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import com.atlassian.troubleshooting.jfr.service.JfrAlwaysOnRecordingService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUserLimitServiceEventProxy
implements LicenseUserLimitService {
    private static final Logger LOG = LoggerFactory.getLogger(JfrAlwaysOnRecordingService.class);
    private final LicenseUserLimitService delegate;
    private final EventPublisher eventPublisher;
    private final LicenseUserLimitConfigurationStore.Product product;

    public LicenseUserLimitServiceEventProxy(LicenseUserLimitService delegate, EventPublisher eventPublisher, LicenseUserLimitConfigurationStore.Product product) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.product = product;
    }

    @Override
    public LicenseUserLimitConfiguration getLicenseUserLimitConfig() {
        return this.delegate.getLicenseUserLimitConfig();
    }

    @Override
    public void setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) throws InvalidLicenseUserLimitException {
        Objects.requireNonNull(licenseUserLimitConfiguration, "licenseUserLimitConfiguration cannot be null");
        this.delegate.setLicenseUserLimitConfig(licenseUserLimitConfiguration);
        LOG.debug("sending analytics event for licenseUserLimitConfiguration update");
        this.eventPublisher.publish((Object)LicenseUserLimitConfigUpdateEvent.of(licenseUserLimitConfiguration, this.product));
    }
}

