/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LdapUrlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUrlParser.class);
    private static final String LDAP_URL_ATTR = "ldap.url";
    private static final Set<String> LDAP_PROTOCOLS = ImmutableSet.of((Object)"ldap", (Object)"ldaps");

    public static String getLdapUrlAttr() {
        return LDAP_URL_ATTR;
    }

    public Optional<InetSocketAddress> getLdapInetSocketAddress(String urlString) {
        if (urlString != null) {
            try {
                URI url = new URI(urlString);
                if (LDAP_PROTOCOLS.contains(url.getScheme())) {
                    return Optional.of(new InetSocketAddress(url.getHost(), url.getPort()));
                }
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Illegal LDAP URL:" + urlString, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    Optional<InetSocketAddress> getLdapInetSocketAddress(Directory directory) {
        return this.getLdapInetSocketAddress((String)directory.getAttributes().get(LDAP_URL_ATTR));
    }
}

