/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support.database.mysql;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CollationCheck.class);
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder healthStatusBuilder;

    public CollationCheck(BambooHealthCheckService bambooHealthCheckService, SupportHealthStatusBuilder healthStatusBuilder) {
        this.bambooHealthCheckService = bambooHealthCheckService;
        this.healthStatusBuilder = healthStatusBuilder;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        try {
            if (this.bambooHealthCheckService.getMySQLChecks().isCollationCheckPass()) {
                return this.healthStatusBuilder.ok(this, "bamboo.healthcheck.mysql.collation.valid", new Serializable[0]);
            }
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.mysql.collation.fail", new Serializable[0]);
        }
        catch (IllegalStateException e) {
            LOG.info("Exception caught during collation check", (Throwable)e);
            return this.healthStatusBuilder.critical(this, "bamboo.healthcheck.database.query.no.results", new Serializable[0]);
        }
    }
}

