/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo;

import com.atlassian.bamboo.beehive.BambooClusterNodeHeartbeatService;
import com.atlassian.bamboo.beehive.BambooNodeStatus;
import com.atlassian.spring.container.LazyComponentReference;
import com.atlassian.troubleshooting.api.ClusterNode;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.LicenseService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BambooClusterService
implements ClusterService {
    private final LicenseService licenseService;
    private final Supplier<BambooClusterNodeHeartbeatService> bambooClusterNodeHeartbeatServiceSupplier;

    @VisibleForTesting
    protected BambooClusterService(@NotNull LicenseService licenseService, @NotNull Supplier<BambooClusterNodeHeartbeatService> bambooClusterNodeHeartbeatServiceSupplier) {
        this.licenseService = licenseService;
        this.bambooClusterNodeHeartbeatServiceSupplier = bambooClusterNodeHeartbeatServiceSupplier;
    }

    public BambooClusterService(@NotNull LicenseService licenseService) {
        this(licenseService, (Supplier<BambooClusterNodeHeartbeatService>)new LazyComponentReference("clusterNodeHeartbeatService"));
    }

    @Override
    public Optional<ClusterNode> getCurrentNode() {
        return this.bambooClusterNodeHeartbeatServiceSupplier.get().getNodeStatuses().stream().filter(BambooNodeStatus::isPrimary).findFirst().map(this::nodeStatus2ClusterNode);
    }

    @Override
    public Optional<String> getCurrentNodeId() {
        return Optional.of(this.bambooClusterNodeHeartbeatServiceSupplier.get().getNodeId());
    }

    @Override
    public boolean isClustered() {
        return this.licenseService.isLicensedForDataCenter();
    }

    @Override
    @NotNull
    public Set<String> getNodeIds() {
        return this.bambooClusterNodeHeartbeatServiceSupplier.get().getNodeStatuses().stream().map(BambooNodeStatus::getNodeId).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<ClusterNode> getNodes() {
        return this.bambooClusterNodeHeartbeatServiceSupplier.get().getNodeStatuses().stream().map(this::nodeStatus2ClusterNode).collect(Collectors.toList());
    }

    @Override
    public Optional<Integer> getNodeCount() {
        return Optional.of(this.bambooClusterNodeHeartbeatServiceSupplier.get().getNodeStatuses().size());
    }

    private ClusterNode nodeStatus2ClusterNode(@NotNull BambooNodeStatus ns) {
        return new ClusterNode(ns.getNodeId(), null, ns.getNodeName());
    }
}

