/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.persistence;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseUserLimitConfigurationStore {
    @VisibleForTesting
    public static final String KEY_TEMPLATE = "com.atlassian.troubleshooting.healthcheck.licenseuserlimit.%s";
    @VisibleForTesting
    public static final LicenseUserLimitConfiguration DEFAULT_CONFIGURATION = new LicenseUserLimitConfiguration(10, true);
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUserLimitConfigurationStore.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public LicenseUserLimitConfigurationStore(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void storeConfiguration(Product product, @Nonnull LicenseUserLimitConfiguration configuration) {
        try {
            String configurationJson = this.objectMapper.writeValueAsString((Object)configuration);
            this.pluginSettingsFactory.createGlobalSettings().put(product.getKey(), (Object)configurationJson);
        }
        catch (IOException e) {
            LOG.error(String.format("Couldn't persist %s license user limit configuration with key '%s'", new Object[]{product, product.getKey()}), (Throwable)e);
        }
    }

    public LicenseUserLimitConfiguration getConfiguration(Product product) {
        Object storedConfigObject = this.pluginSettingsFactory.createGlobalSettings().get(product.getKey());
        if (storedConfigObject == null) {
            return DEFAULT_CONFIGURATION;
        }
        try {
            return (LicenseUserLimitConfiguration)this.objectMapper.readValue((String)storedConfigObject, LicenseUserLimitConfiguration.class);
        }
        catch (IOException e) {
            LOG.error(String.format("Couldn't read %s license user limit configuration key '%s'", new Object[]{product, product.getKey()}), (Throwable)e);
            return DEFAULT_CONFIGURATION;
        }
    }

    public static enum Product {
        JSM(String.format("com.atlassian.troubleshooting.healthcheck.licenseuserlimit.%s", "jsm")),
        JSW(String.format("com.atlassian.troubleshooting.healthcheck.licenseuserlimit.%s", "jsw")),
        CONFLUENCE(String.format("com.atlassian.troubleshooting.healthcheck.licenseuserlimit.%s", "confluence"));

        private final String key;

        private Product(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

