/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.directory.AbstractDirectoryHealthCheck;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapConfiguredCondition;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapErrorDetails;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapType;
import com.atlassian.troubleshooting.healthcheck.checks.directory.LdapUrlParser;
import com.atlassian.troubleshooting.healthcheck.impl.MessageSet;
import com.atlassian.troubleshooting.healthcheck.service.NetworkConnectivityService;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationHealthCheck
extends AbstractDirectoryHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationHealthCheck.class);
    private static final String MSG_KEY_MAJOR_BIND_FAIL = "healthcheck.directory.ldap.authentication.bind.fail";
    private static final String MSG_KEY_OK_CONNECT_FAIL = "healthcheck.directory.ldap.authentication.connect.fail";
    private static final String MSG_KEY_OK = "healthcheck.directory.ldap.authentication.healthy";
    private static final String MSG_KEY_OK_NO_DIRS = "healthcheck.directory.ldap.authentication.healthy.empty";
    private final I18nResolver i18n;
    private final LdapUrlParser urlParser;
    private final NetworkConnectivityService networkInspector;

    public LdapAuthenticationHealthCheck(SupportHealthStatusBuilder supportHealthStatusBuilder, CrowdDirectoryService crowdDirectoryService, I18nResolver i18n, NetworkConnectivityService networkConnectivityService, LdapUrlParser urlParser) {
        super(supportHealthStatusBuilder, crowdDirectoryService);
        this.i18n = i18n;
        this.networkInspector = networkConnectivityService;
        this.urlParser = urlParser;
    }

    @Override
    protected void checkDirectory(MessageSet messageSet, Directory directory) {
        Optional<LdapType> ldapType = LdapType.fromImplClass(directory.getImplementationClass());
        if (!directory.isActive() || !ldapType.isPresent()) {
            return;
        }
        try {
            Optional<InetSocketAddress> addressOptional = this.urlParser.getLdapInetSocketAddress(directory);
            if (!addressOptional.isPresent()) {
                return;
            }
            InetSocketAddress addr = addressOptional.get();
            if (!this.networkInspector.isHostAvailable(addr.getHostName(), addr.getPort())) {
                messageSet.addWarningMessage(directory.getName());
                return;
            }
            this.crowdDirectoryService.testConnection(directory);
        }
        catch (OperationFailedException ex) {
            String errorMessage = ldapType.get().parseErrorMessage(ex.getMessage()).map(details -> this.formatErrorMessage(directory, (LdapErrorDetails)details)).orElse(directory.getName());
            LOGGER.trace("There's a problem encountered when running the LDAP integration healthcheck: {}", (Object)ex.getMessage());
            messageSet.addErrorMessage(errorMessage);
        }
    }

    @Override
    public boolean isDirectorySupported(Directory directory) {
        return LdapConfiguredCondition.isDirectorySupported(directory);
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    protected String getCredentialsFailKeyMessage() {
        return MSG_KEY_MAJOR_BIND_FAIL;
    }

    @Override
    protected String getConnectFailKeyMessage() {
        return MSG_KEY_OK_CONNECT_FAIL;
    }

    @Override
    protected String getNoDirsKeyMessage() {
        return MSG_KEY_OK_NO_DIRS;
    }

    @Override
    protected String getOkKeyMessage() {
        return MSG_KEY_OK;
    }

    private String formatErrorMessage(Directory directory, LdapErrorDetails details) {
        return "(" + directory.getName() + "). Reason: " + this.i18n.getRawText(details.getMessage()) + " (Error " + details.getCode() + ", data " + details.getMessageCode() + ")";
    }
}

