/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.directory;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.directory.AbstractDirectoryHealthCheck;
import com.atlassian.troubleshooting.healthcheck.checks.directory.CrowdConfiguredCondition;
import com.atlassian.troubleshooting.healthcheck.impl.MessageSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdAuthenticationHealthCheck
extends AbstractDirectoryHealthCheck {
    private static final String MSG_KEY_MAJOR_BIND_FAIL = "healthcheck.directory.crowd.authentication.bind.fail";
    private static final String MSG_KEY_WARNING_CONNECT_FAIL = "healthcheck.directory.crowd.authentication.connect.fail";
    private static final String MSG_KEY_OK = "healthcheck.directory.crowd.authentication.healthy";
    private static final String MSG_KEY_OK_NO_DIRS = "healthcheck.directory.crowd.authentication.healthy.empty";
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdAuthenticationHealthCheck.class);

    public CrowdAuthenticationHealthCheck(SupportHealthStatusBuilder supportHealthStatusBuilder, CrowdDirectoryService crowdDirectoryService) {
        super(supportHealthStatusBuilder, crowdDirectoryService);
    }

    @Override
    protected void checkDirectory(MessageSet messageSet, Directory directory) {
        if (!directory.isActive()) {
            return;
        }
        try {
            this.crowdDirectoryService.testConnection(directory);
        }
        catch (OperationFailedException ex) {
            if (ex.getCause() instanceof InvalidAuthenticationException) {
                messageSet.addErrorMessage(directory.getName() + ": " + ex.getMessage());
            } else {
                messageSet.addWarningMessage(directory.getName());
            }
            LOGGER.trace("There's a problem encountered when running the Crowd integration healthcheck: {}", (Object)ex.getMessage());
        }
    }

    @Override
    public boolean isDirectorySupported(Directory directory) {
        return CrowdConfiguredCondition.isDirectorySupported(directory);
    }

    @Override
    protected String getCredentialsFailKeyMessage() {
        return MSG_KEY_MAJOR_BIND_FAIL;
    }

    @Override
    protected String getConnectFailKeyMessage() {
        return MSG_KEY_WARNING_CONNECT_FAIL;
    }

    @Override
    protected String getNoDirsKeyMessage() {
        return MSG_KEY_OK_NO_DIRS;
    }

    @Override
    protected String getOkKeyMessage() {
        return MSG_KEY_OK;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }
}

