/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.jfr.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.troubleshooting.jfr.manager.JfrRecordingManager;
import com.atlassian.troubleshooting.stp.security.PermissionValidationService;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/jfr")
@Produces(value={"application/json"})
@Singleton
@WebSudoRequired
public class JfrConfigurationResource {
    private final PermissionValidationService permissionValidationService;
    private final JfrRecordingManager jfrRecordingManager;

    @Autowired
    public JfrConfigurationResource(PermissionValidationService permissionValidationService, JfrRecordingManager jfrRecordingManager) {
        this.permissionValidationService = Objects.requireNonNull(permissionValidationService);
        this.jfrRecordingManager = Objects.requireNonNull(jfrRecordingManager);
    }

    @ExperimentalApi
    @GET
    @Path(value="capabilities")
    public Response getCapabilities() {
        this.permissionValidationService.validateIsSysadmin();
        return Response.ok((Object)this.jfrRecordingManager.getCapabilities()).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="configurations")
    public Response getConfigurations() {
        this.permissionValidationService.validateIsSysadmin();
        return Response.ok((Object)this.jfrRecordingManager.getActiveConfiguration()).build();
    }
}

