/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.mailqueue;

import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.troubleshooting.healthcheck.checks.eol.ClockFactory;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.ApplicationMailQueue;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.config.MailQueueHealthCheckProperties;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MailQueueObserver {
    private final ApplicationMailQueue mailQueue;
    private final Clock clock;
    private final MailQueueHealthCheckProperties mailQueueHealthCheckProperties;

    public MailQueueObserver(@Nonnull ApplicationMailQueue mailQueue, ClockFactory clockFactory, MailQueueHealthCheckProperties mailQueueHealthCheckProperties) {
        this.mailQueue = mailQueue;
        this.clock = clockFactory.makeClock();
        this.mailQueueHealthCheckProperties = mailQueueHealthCheckProperties;
    }

    public boolean isOldestEmailAboveTimeThreshold() {
        Optional<MailQueueItem> optionalOldestEmail = this.mailQueue.getMailQueueItems().stream().min(Comparator.comparing(MailQueueItem::getDateQueued));
        return optionalOldestEmail.filter(mailQueueItem -> this.isDateAboveTimeThreshold(mailQueueItem.getDateQueued())).isPresent();
    }

    private boolean isDateAboveTimeThreshold(Date dateQueued) {
        LocalDateTime dateTimeQueuedWithThreshold = dateQueued.toInstant().atZone(this.clock.getZone()).toLocalDateTime().plusMinutes(this.mailQueueHealthCheckProperties.getMailQueueStayThresholdMinutes());
        return !dateTimeQueuedWithThreshold.isAfter(LocalDateTime.now(this.clock));
    }

    protected int getAllowedMinutesToStay() {
        return this.mailQueueHealthCheckProperties.getMailQueueStayThresholdMinutes();
    }

    protected long getMailQueueSize() {
        return this.mailQueue.size();
    }

    protected boolean isMailQueueSending() {
        return this.mailQueue.isSending();
    }

    protected int getMailErrorQueueSize() {
        return this.mailQueue.errorSize();
    }
}

