/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base64ObjectSerializerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64ObjectSerializerUtil.class);

    private Base64ObjectSerializerUtil() {
    }

    public static <T extends Serializable> Optional<T> deserialize(String serialized) {
        Optional<Serializable> optional;
        byte[] data = Base64.getDecoder().decode(serialized);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            Object o = ois.readObject();
            ois.close();
            optional = Optional.of((Serializable)o);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to deserialize task monitor", (Throwable)e);
                return Optional.empty();
            }
        }
        ois.close();
        return optional;
    }

    public static <T extends Serializable> String serialize(T object) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            string = Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to serialize task monitor", (Throwable)e);
                return "";
            }
        }
        baos.close();
        return string;
    }
}

