/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.mailqueue;

import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.MailQueueObserver;
import java.io.Serializable;
import java.util.Optional;

public class MailErrorQueueHealthCheck
implements SupportHealthCheck {
    private final MailQueueObserver mailQueueObserver;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final ClusterService clusterService;

    public MailErrorQueueHealthCheck(ClusterService clusterService, SupportHealthStatusBuilder supportHealthStatusBuilder, MailQueueObserver mailQueueObserver) {
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.mailQueueObserver = mailQueueObserver;
        this.clusterService = clusterService;
    }

    @Override
    public boolean isNodeSpecific() {
        return true;
    }

    @Override
    public SupportHealthStatus check() {
        return this.checkErrorQueueSize().orElseGet(this::healthyStatus);
    }

    private Optional<SupportHealthStatus> checkErrorQueueSize() {
        int errorQueueSize = this.mailQueueObserver.getMailErrorQueueSize();
        if (errorQueueSize <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.supportHealthStatusBuilder.warning(this, this.getI18nClusterFlavorMessage("healthcheck.mail.error.queue.failed"), Integer.valueOf(errorQueueSize)));
    }

    private SupportHealthStatus healthyStatus() {
        return this.supportHealthStatusBuilder.ok(this, this.getI18nClusterFlavorMessage("healthcheck.mail.error.queue.healthy"), new Serializable[0]);
    }

    private String getI18nClusterFlavorMessage(String i18nKey) {
        return this.clusterService.isClustered() ? i18nKey + ".dc" : i18nKey + ".server";
    }
}

