/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.analytic.DailyAnalyticsEventSupplier;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.analytic.LocalBackupsAnalyticEvent;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackupHealthCheck
implements SupportHealthCheck,
DailyAnalyticsEventSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBackupHealthCheck.class);
    private static final AtomicInteger RECENT_FOUND_BACKUPS = new AtomicInteger();
    protected final ClusterService clusterService;
    protected final SupportHealthStatusBuilder statusBuilder;
    protected final I18nResolver i18nResolver;
    private final AtomicInteger currentFoundZips = new AtomicInteger();

    public AbstractBackupHealthCheck(ClusterService clusterService, SupportHealthStatusBuilder statusBuilder, I18nResolver i18nResolver) {
        this.clusterService = clusterService;
        this.statusBuilder = statusBuilder;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public boolean isNodeSpecific() {
        return true;
    }

    protected abstract void checkImpl(List<String> var1);

    @Override
    public SupportHealthStatus check() {
        ArrayList<String> failures = new ArrayList<String>();
        this.checkImpl(failures);
        RECENT_FOUND_BACKUPS.set(this.currentFoundZips.getAndSet(0));
        if (failures.isEmpty()) {
            return this.statusBuilder.builder(this).message(this.i18nResolver.getText(this.getHealthyI18nKey(), new Serializable[]{this.getNodeId()})).build();
        }
        return this.statusBuilder.builder(this).severity(SupportHealthStatus.Severity.WARNING).message(String.join((CharSequence)" ", failures)).build();
    }

    @Override
    public List<Object> getDailyAnalyticEvents() {
        return ImmutableList.of((Object)new LocalBackupsAnalyticEvent(RECENT_FOUND_BACKUPS.get()));
    }

    private String getHealthyI18nKey() {
        return this.clusterService.isClustered() ? "healthcheck.backups.local.healthy.cluster" : "healthcheck.backups.local.healthy";
    }

    @Nullable
    protected static File[] listZips(String path) {
        try {
            return new File(path).listFiles(AbstractBackupHealthCheck::isZipFile);
        }
        catch (SecurityException e) {
            LOG.debug("No permission to read backup files in directory " + path, (Throwable)e);
            return null;
        }
    }

    protected void checkDirectory(List<String> failures, String path) {
        this.checkDirectory(failures, path, AbstractBackupHealthCheck.listZips(path));
    }

    protected void checkDirectory(List<String> failures, String path, File[] zips) {
        if (AbstractBackupHealthCheck.isNullOrEmpty(zips)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed backups health check, found zip files in '{}' directory: {}", (Object)path, (Object)AbstractBackupHealthCheck.getFileNamesFormatted(zips));
        }
        failures.add(this.getFailureText(zips.length, path));
        this.currentFoundZips.addAndGet(zips.length);
    }

    private String getFailureText(int numberOfBackups, String directoryPath) {
        if (this.clusterService.isClustered()) {
            return this.i18nResolver.getText("healthcheck.backups.local.failed.cluster", new Serializable[]{Integer.valueOf(numberOfBackups), directoryPath, this.getNodeId()});
        }
        return this.i18nResolver.getText("healthcheck.backups.local.failed", new Serializable[]{Integer.valueOf(numberOfBackups), directoryPath});
    }

    @Nullable
    protected String getNodeId() {
        return this.clusterService.getCurrentNodeId().orElse(null);
    }

    protected static boolean isNullOrEmpty(File[] files) {
        return files == null || files.length == 0;
    }

    protected static String getFileNamesFormatted(File[] files) {
        return Arrays.stream(files).map(File::getName).collect(Collectors.joining(", "));
    }

    protected static boolean isZipFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(".zip");
    }
}

