/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class HSQLHealthCheck
implements SupportHealthCheck {
    private final I18nResolver i18nResolver;
    private final BambooLicenseManager bambooLicenseManager;
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;

    public HSQLHealthCheck(I18nResolver i18nResolver, BambooHealthCheckService bambooHealthCheckService, BambooLicenseManager bambooLicenseManager, SupportHealthStatusBuilder supportHealthStatusBuilder) {
        this.i18nResolver = i18nResolver;
        this.bambooHealthCheckService = bambooHealthCheckService;
        this.bambooLicenseManager = bambooLicenseManager;
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        DatabaseType databaseType;
        if (!this.isDevMode() && this.isEmbeddedDatabase(databaseType = this.bambooHealthCheckService.getDatabaseType())) {
            if (this.bambooLicenseManager.isEvaluation() || this.bambooLicenseManager.isDeveloper() || this.bambooLicenseManager.isDemonstration()) {
                return this.supportHealthStatusBuilder.warning(this, "bamboo.healthcheck.hsql.database.on.eval", new Serializable[]{this.getDatabaseName(databaseType)});
            }
            return this.supportHealthStatusBuilder.major(this, "bamboo.healthcheck.hsql.database.on.production", new Serializable[]{this.getDatabaseName(databaseType)});
        }
        return this.supportHealthStatusBuilder.ok(this, "bamboo.healthcheck.hsql.valid", new Serializable[0]);
    }

    @VisibleForTesting
    boolean isDevMode() {
        return BuildUtils.isDevMode();
    }

    private boolean isEmbeddedDatabase(@Nonnull DatabaseType databaseType) {
        try {
            return databaseType.isEmbedded();
        }
        catch (NoSuchMethodError e) {
            return databaseType == DatabaseType.HSQL;
        }
    }

    @Nonnull
    private String getDatabaseName(@Nonnull DatabaseType databaseType) {
        String i18nKey;
        try {
            i18nKey = databaseType.getI18nKey();
        }
        catch (NoSuchMethodError e) {
            i18nKey = "bamboo.healthcheck.hsql.database.type.name";
        }
        return this.i18nResolver.getText(i18nKey);
    }
}

