/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.k8s;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.healthcheck.Application;
import com.atlassian.troubleshooting.k8s.HelmValuesEvent;
import com.atlassian.troubleshooting.k8s.HelmValuesFile;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HelmValuesParser {
    private static final String DEFAULT_HELM_ANALYTICS_FILE_PATH = "/opt/atlassian/helm/analytics.json";
    private static final String HELM_ANALYTICS_FILE_PATH_PROPERTY = "helm.analytics.file.path";
    private static final Logger LOG = LoggerFactory.getLogger(HelmValuesParser.class);
    private final ApplicationProperties properties;

    @Autowired
    public HelmValuesParser(ApplicationProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    public static Path getValuesFilePath() {
        return Paths.get(System.getProperty(HELM_ANALYTICS_FILE_PATH_PROPERTY, DEFAULT_HELM_ANALYTICS_FILE_PATH), new String[0]);
    }

    public Optional<HelmValuesEvent> getAnalyticsEvent() {
        Path valuesFilePath = HelmValuesParser.getValuesFilePath();
        HelmValuesFile valuesFile = HelmValuesParser.parseHelmValuesFile(valuesFilePath);
        return valuesFile != null ? Optional.of(this.createHelmValuesEvent(valuesFile)) : Optional.empty();
    }

    private static HelmValuesFile parseHelmValuesFile(Path valuesFilePath) {
        HelmValuesFile helmValuesFile;
        block8: {
            LOG.debug("Reading helm analytics from {}", (Object)valuesFilePath);
            InputStream stream = Files.newInputStream(valuesFilePath, new OpenOption[0]);
            try {
                ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                helmValuesFile = (HelmValuesFile)objectMapper.readValue(stream, HelmValuesFile.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed to parse helm analytics file", (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return helmValuesFile;
    }

    private HelmValuesEvent createHelmValuesEvent(HelmValuesFile valuesFile) {
        return new HelmValuesEvent(Application.byAppDisplayName(this.properties.getDisplayName()), valuesFile.getReplicas(), valuesFile.getIngressType(), valuesFile.getK8sVersion(), valuesFile.getServiceType(), valuesFile.getDbType(), valuesFile.getImageTag(), valuesFile.isSharedHomePVCCreated(), valuesFile.isClusteringEnabled(), valuesFile.isJmxEnabled(), valuesFile.isServiceMonitorCreated(), valuesFile.isGrafanaDashboardsCreated(), valuesFile.isS3AvatarsEnabled(), valuesFile.isS3AttachmentsStorageEnabled(), valuesFile.isBitbucketMeshEnabled());
    }
}

