/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.k8s;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.troubleshooting.k8s.HelmValuesEvent;
import com.atlassian.troubleshooting.k8s.HelmValuesParser;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class KubernetesAnalyticsService
implements LifecycleAware,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesAnalyticsService.class);
    private static final String EVERY_DAY_AT_MIDNIGHT_CRON = "0 0 0 ? * * *";
    private static final String DAILY_TASK_ID = "HelmValuesDailyEventPublishingTask";
    private static final JobId DAILY_JOB_ID = JobId.of((String)"HelmValuesDailyEventPublishingTask");
    private static final JobRunnerKey DAILY_JOB_RUNNER_KEY = JobRunnerKey.of((String)"HelmValuesDailyEventPublishingTask");
    private final EventPublisher eventPublisher;
    private final HelmValuesParser helmValuesParser;
    private final SchedulerServiceProvider schedulerServiceProvider;
    private SchedulerService schedulerService;

    @Autowired
    public KubernetesAnalyticsService(EventPublisher eventPublisher, HelmValuesParser helmValuesParser, SchedulerService schedulerService, SchedulerServiceProvider schedulerServiceProvider) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.helmValuesParser = Objects.requireNonNull(helmValuesParser);
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.schedulerServiceProvider = Objects.requireNonNull(schedulerServiceProvider);
    }

    public void onStart() {
        this.registerHelmAnalyticsDailyJob();
        this.scheduleAnalyticsSendingJob(Schedule.forCronExpression((String)EVERY_DAY_AT_MIDNIGHT_CRON));
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)DAILY_TASK_ID));
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        LOG.debug("Helm values analytics scheduler started job.");
        try {
            this.publishHelmAnalyticsEvent();
            LOG.debug("Helm values analytics event publisher finished job successfully.");
            return JobRunnerResponse.success();
        }
        catch (Exception exc) {
            LOG.error("Error occurred while sending Helm analytics event.", (Throwable)exc);
            return JobRunnerResponse.failed((Throwable)exc);
        }
    }

    void publishHelmAnalyticsEvent() {
        Optional<HelmValuesEvent> analyticsEvent = this.helmValuesParser.getAnalyticsEvent();
        if (analyticsEvent.isPresent()) {
            LOG.debug("Publishing Helm analytics event.");
            this.eventPublisher.publish((Object)analyticsEvent.get());
        }
    }

    private void registerHelmAnalyticsDailyJob() {
        this.schedulerService = this.schedulerServiceProvider.getSchedulerService();
        this.schedulerService.registerJobRunner(DAILY_JOB_RUNNER_KEY, (JobRunner)this);
    }

    private void scheduleAnalyticsSendingJob(Schedule schedule) {
        try {
            JobConfig jobConfig = this.buildJobConfig(schedule);
            this.schedulerService.scheduleJob(DAILY_JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOG.error("Failed to schedule Helm values analytics publisher job.", (Throwable)e);
        }
    }

    private JobConfig buildJobConfig(Schedule schedule) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)DAILY_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(schedule);
    }
}

