/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.info;

import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.troubleshooting.api.healthcheck.FileSystemInfo;
import com.atlassian.troubleshooting.api.healthcheck.RuntimeHelper;
import com.atlassian.troubleshooting.stp.spi.Version;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitEnvironmentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GitEnvironmentProvider.class);
    private static final String CAPABILITY_GIT = "system.git.executable";
    private static final String CAPABILITY_JGIT = "org.eclipse.jgit";
    private static final String COMMAND = "--version";
    private static final Pattern GIT_VERSION_PATTERN = Pattern.compile("^git version (.*)");
    private final RuntimeHelper runtimeHelper;
    private final FileSystemInfo fileSystemInfo;
    private final CapabilityContext capabilityContext;

    public GitEnvironmentProvider(CapabilityContext capabilityContext, FileSystemInfo fileSystemInfo, RuntimeHelper runtimeHelper) {
        this.capabilityContext = Objects.requireNonNull(capabilityContext);
        this.fileSystemInfo = Objects.requireNonNull(fileSystemInfo);
        this.runtimeHelper = Objects.requireNonNull(runtimeHelper);
    }

    @VisibleForTesting
    static String getCapabilityGit() {
        return CAPABILITY_GIT;
    }

    @VisibleForTesting
    static String getCapabilityJGit() {
        return CAPABILITY_JGIT;
    }

    @VisibleForTesting
    static String getCommand() {
        return COMMAND;
    }

    public String getCapabilityType() {
        return this.getGitPath().isPresent() ? CAPABILITY_GIT : CAPABILITY_JGIT;
    }

    public Optional<String> getGitPath() {
        return Optional.ofNullable(this.capabilityContext.getCapabilityValue(CAPABILITY_GIT));
    }

    public boolean isGitExecutable() {
        return this.getGitPath().map(this.fileSystemInfo::isExecutable).orElse(false);
    }

    public Optional<String> getGitVersion() {
        Optional<String> gitPath = this.getGitPath();
        if (this.isGitExecutable() && gitPath.isPresent()) {
            return this.getGitVersionFromShell(this.getGitPath().get(), COMMAND);
        }
        return Optional.empty();
    }

    private Optional<String> getGitVersionFromShell(String ... command) {
        return this.runtimeHelper.spawnProcessSafely(command).map(process -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string = this.parseVersion(reader.readLine()).orElse(null);
                return string;
            }
            catch (IOException e) {
                LOG.warn("Failed on executing command: {}", (Object)command, (Object)e);
                return null;
            }
        });
    }

    private Optional<String> parseVersion(String commandOutput) {
        Matcher matcher = GIT_VERSION_PATTERN.matcher(commandOutput);
        if (matcher.matches()) {
            return Optional.ofNullable(Version.of(matcher.group(1)).toString());
        }
        return Optional.empty();
    }
}

