/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.vuln;

import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.vuln.CveValidator;
import com.atlassian.troubleshooting.healthcheck.checks.vuln.model.CveRecord;
import com.atlassian.troubleshooting.stp.hercules.regex.cacheables.ResultWithFallback;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityVulnerabilityHealthCheck
implements SupportHealthCheck {
    private final CveValidator cveValidator;
    private final SupportHealthStatusBuilder statusBuilder;

    @Autowired
    public SecurityVulnerabilityHealthCheck(SupportHealthStatusBuilder statusBuilder, CveValidator cveValidator) {
        this.cveValidator = Objects.requireNonNull(cveValidator);
        this.statusBuilder = Objects.requireNonNull(statusBuilder);
    }

    @Override
    public SupportHealthStatus check() {
        ResultWithFallback<Iterable<CveRecord>> result = this.cveValidator.validateCves();
        Iterable<CveRecord> cves = result.getValue();
        if (Iterables.isEmpty(cves)) {
            String msg = result.isFallback() ? "healthcheck.vuln.ok.offline" : "healthcheck.vuln.ok";
            return this.statusBuilder.ok(this, msg, new Serializable[0]);
        }
        String msg = result.isFallback() ? "healthcheck.vuln.warning.offline" : "healthcheck.vuln.warning";
        SupportHealthStatusBuilder.Builder warning = this.statusBuilder.builder(this).severity(SupportHealthStatus.Severity.WARNING).i18nMessage(msg, new Serializable[0]);
        for (CveRecord cve : cves) {
            warning.additionalLink(cve.getAdvisory().getName(), cve.getAdvisory().getUrl());
        }
        return warning.build();
    }
}

