/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo;

import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.troubleshooting.api.healthcheck.LicenseService;
import java.util.Date;
import java.util.Objects;

public class BambooLicenseService
implements LicenseService {
    private final BambooLicenseManager licenseManager;

    public BambooLicenseService(BambooLicenseManager licenseManager) {
        this.licenseManager = Objects.requireNonNull(licenseManager);
    }

    @Override
    public boolean isEvaluation() {
        return this.licenseManager.isEvaluation();
    }

    @Override
    public boolean userCanRequestTechnicalSupport() {
        return !LicenseService.isStarterLicense((ProductLicense)this.licenseManager.getLicense(), Product.BAMBOO.getNamespace());
    }

    @Override
    public boolean isWithinMaintenanceFor(Date date) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isLicensedForDataCenter() {
        try {
            return this.licenseManager.isDataCenter();
        }
        catch (IncompatibleClassChangeError ex) {
            return false;
        }
    }
}

