/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.output;

import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.stp.properties.PropertyStore;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.NonLazyElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XmlSupportDataFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSupportDataFormatter.class);
    private static final OutputFormat XML_OUTPUT_FORMAT = OutputFormat.createPrettyPrint();
    private static final String UNKNOWN = "unknown";
    private static final String NAME_START_CHAR = "_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
    private static final String NAME_CHAR = "_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd.0-9\u00b7\u0300-\u036f\u203f-\u2040-";
    private static final Pattern NAME_START_CHAR_PATTERN = Pattern.compile("[^_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]");
    private static final Pattern NAME_CHAR_PATTERN = Pattern.compile("[^_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd.0-9\u00b7\u0300-\u036f\u203f-\u2040-]");
    private final ClusterService clusterService;

    @Autowired
    public XmlSupportDataFormatter(ClusterService clusterService) {
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    private static String toXmlString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, XML_OUTPUT_FORMAT);
            xmlWriter.write(document);
        }
        catch (Exception e) {
            LOG.error("Couldn't write XML output", (Throwable)e);
        }
        return stringWriter.toString();
    }

    private static void addAtstVersionElement(@Nullable String atstVersion, Element root) {
        Element atstVersionElement = root.addElement("atst-version");
        atstVersionElement.setText(atstVersion != null ? atstVersion : UNKNOWN);
    }

    private static void addProductElement(String applicationName, String applicationVersion, Element root) {
        Element productElement = root.addElement("product");
        productElement.addAttribute("name", applicationName);
        productElement.addAttribute("version", applicationVersion);
    }

    private static void addTimeZoneElement(Element root) {
        String rawTimezone = System.getProperty("user.timezone");
        TimeZone timeZone = TimeZone.getTimeZone(rawTimezone);
        int offsetMS = timeZone.getRawOffset() + (timeZone.inDaylightTime(new Date()) ? timeZone.getDSTSavings() : 0);
        int offsetHour = offsetMS / 1000 / 60 / 60;
        String timezoneStringInGMT = "GMT" + (offsetHour >= 0 ? "+" : "") + offsetHour;
        Element tzElement = root.addElement("timeZone");
        tzElement.setText(timezoneStringInGMT);
    }

    private static void addSenElement(@Nullable String applicationSEN, Element root) {
        Element senElement = root.addElement("sen");
        senElement.setText(applicationSEN != null ? applicationSEN : UNKNOWN);
    }

    private static void addServerIdElement(@Nullable String applicationID, Element root) {
        Element serverIdElement = root.addElement("serverId");
        serverIdElement.setText(applicationID != null ? applicationID : UNKNOWN);
    }

    private static void loadStore(PropertyStore store, Element element, Properties xmlElementNames) {
        String key;
        for (Map.Entry<String, String> entry : store.getValues().entrySet()) {
            if (entry.getValue() == null || StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            key = xmlElementNames.getProperty(entry.getKey(), entry.getKey());
            try {
                Element valueElement = element.addElement(XmlSupportDataFormatter.escapeKeysForXMLOutput(key));
                valueElement.setText(entry.getValue());
            }
            catch (IllegalAddException e) {
                LOG.error("Unable to add child element '{}' to element '{}'...", new Object[]{key, element.getName(), e});
            }
            catch (IllegalArgumentException iae) {
                XmlSupportDataFormatter.handleBadTagNameException(key, element, iae);
            }
        }
        for (Map.Entry<String, Object> entry : store.getCategories().entrySet()) {
            key = xmlElementNames.getProperty(entry.getKey(), entry.getKey());
            Iterable categoryList = (Iterable)entry.getValue();
            for (PropertyStore childObject : categoryList) {
                if (childObject != null) {
                    try {
                        Element listChildElement = element.addElement(XmlSupportDataFormatter.escapeKeysForXMLOutput(key));
                        XmlSupportDataFormatter.loadStore(childObject, listChildElement, xmlElementNames);
                    }
                    catch (IllegalArgumentException iae) {
                        XmlSupportDataFormatter.handleBadTagNameException(key, element, iae);
                    }
                    continue;
                }
                LOG.warn("Couldn't add child object of type '{}' with key '{}' to PropertyStore.", (Object)((List)entry.getValue()).getClass().getCanonicalName(), (Object)key);
            }
        }
    }

    private static void handleBadTagNameException(String key, Element element, Exception e) {
        LOG.info("Did not add child element '{}' to element '{}' making application.xml for the support zip.", new Object[]{key, element.getName(), e});
    }

    private static String escapeKeysForXMLOutput(String key) {
        String escapedKey = key;
        if (!(escapedKey = escapedKey.replace(' ', '-')).isEmpty() && NAME_START_CHAR_PATTERN.matcher(escapedKey.subSequence(0, 1)).matches()) {
            escapedKey = "x" + escapedKey;
        }
        escapedKey = NAME_CHAR_PATTERN.matcher(escapedKey).replaceAll(".");
        return escapedKey;
    }

    public String getFormattedProperties(PropertyStore properties, Properties propertyNameMappings, @Nullable String atstVersion, String applicationName, String applicationVersion, @Nullable String applicationSEN, @Nullable String applicationID) {
        Document doc = DocumentHelper.createDocument();
        NonLazyElement root = new NonLazyElement("properties");
        doc.setRootElement((Element)root);
        XmlSupportDataFormatter.addAtstVersionElement(atstVersion, (Element)root);
        XmlSupportDataFormatter.addProductElement(applicationName, applicationVersion, (Element)root);
        XmlSupportDataFormatter.addTimeZoneElement((Element)root);
        XmlSupportDataFormatter.addSenElement(applicationSEN, (Element)root);
        XmlSupportDataFormatter.addServerIdElement(applicationID, (Element)root);
        this.addClusterInfoElement((Element)root);
        XmlSupportDataFormatter.loadStore(properties, (Element)root, propertyNameMappings);
        return XmlSupportDataFormatter.toXmlString(doc);
    }

    private void addClusterInfoElement(Element root) {
        if (!this.clusterService.isClustered()) {
            return;
        }
        Element clusterInfoElement = root.addElement("cluster-information");
        this.addNodeCountElement(clusterInfoElement);
        this.addNodesElement(clusterInfoElement);
    }

    private void addNodeCountElement(Element clusterInfoElement) {
        Element nodeCountElement = clusterInfoElement.addElement("node-count");
        int nodeCount = this.clusterService.getNodeCount().orElseThrow(IllegalStateException::new);
        nodeCountElement.setText(String.valueOf(nodeCount));
    }

    private void addNodesElement(Element clusterInfoElement) {
        Element nodesElement = clusterInfoElement.addElement("nodes");
        this.clusterService.getNodes().forEach(node -> {
            Element nodeElement = nodesElement.addElement("node");
            nodeElement.addAttribute("id", node.getId());
            node.getInetAddress().ifPresent(addr -> nodeElement.addAttribute("ip-address", addr));
        });
    }
}

