/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade.accessors;

import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.LicenseService;
import com.atlassian.troubleshooting.preupgrade.AnalyticsKey;
import com.atlassian.troubleshooting.preupgrade.model.PreUpgradeInfoDto;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class LicenseCompatibilityChecker {
    private final I18nResolver i18n;
    private final SupportApplicationInfo applicationInfo;
    private final LicenseService licenseService;

    @Autowired
    public LicenseCompatibilityChecker(I18nResolver i18n, SupportApplicationInfo applicationInfo, LicenseService licenseService) {
        this.i18n = Objects.requireNonNull(i18n);
        this.applicationInfo = Objects.requireNonNull(applicationInfo);
        this.licenseService = Objects.requireNonNull(licenseService);
    }

    @Nonnull
    private PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus success() {
        return new PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus(PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus.Status.SUCCESS, this.i18n.getText("stp.pup.license.is.valid"), AnalyticsKey.SUCCESS);
    }

    @Nonnull
    private PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus error() {
        String webContext = this.applicationInfo.getBaseURL(UrlMode.RELATIVE);
        return new PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus(PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus.Status.ERROR, this.i18n.getText("stp.pup.license.expired", new Serializable[]{webContext}), AnalyticsKey.NEW_LICENSE_REQUIRED);
    }

    @Nonnull
    public PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus checkCompatibility(Date releaseDate) {
        Objects.requireNonNull(releaseDate);
        return this.licenseService.isWithinMaintenanceFor(releaseDate) ? this.success() : this.error();
    }
}

