/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.support.dc;

import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;

public class LocalAgentsHealthCheck
implements SupportHealthCheck {
    private final BambooLicenseManager bambooLicenseManager;
    private final BambooHealthCheckService bambooHealthCheckService;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;

    public LocalAgentsHealthCheck(BambooLicenseManager bambooLicenseManager, BambooHealthCheckService bambooHealthCheckService, SupportHealthStatusBuilder supportHealthStatusBuilder) {
        this.bambooLicenseManager = bambooLicenseManager;
        this.bambooHealthCheckService = bambooHealthCheckService;
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
    }

    @Override
    public boolean isNodeSpecific() {
        return true;
    }

    @Override
    public SupportHealthStatus check() {
        long localAgentsCount = this.bambooHealthCheckService.getLocalAgentsCount();
        boolean notProductionInstance = this.isNotProductionInstance();
        if (localAgentsCount == 0L) {
            return this.supportHealthStatusBuilder.ok(this, "bamboo.healthcheck.dc.local.agents.valid", new Serializable[0]);
        }
        if (localAgentsCount == 1L) {
            if (notProductionInstance) {
                return this.supportHealthStatusBuilder.warning(this, "bamboo.healthcheck.dc.local.agents.one.eval", new Serializable[0]);
            }
            return this.supportHealthStatusBuilder.warning(this, "bamboo.healthcheck.dc.local.agents.one.production", new Serializable[0]);
        }
        if (notProductionInstance) {
            return this.supportHealthStatusBuilder.warning(this, "bamboo.healthcheck.dc.local.agents.many.eval", new Serializable[0]);
        }
        return this.supportHealthStatusBuilder.major(this, "bamboo.healthcheck.dc.local.agents.many.production", new Serializable[0]);
    }

    private boolean isNotProductionInstance() {
        return this.bambooLicenseManager.isEvaluation() || this.bambooLicenseManager.isDeveloper() || this.bambooLicenseManager.isDemonstration();
    }
}

