/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.spi;

import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.stp.spi.SupportDataModuleDescriptor;
import com.atlassian.troubleshooting.stp.spi.SupportHealthCheckModuleDescriptor;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class TroubleshootingModuleDescriptorFactory
extends DefaultModuleDescriptorFactory
implements ListableModuleDescriptorFactory {
    private static final String SUPPORT_DATA_ELEM_NAME = "support-data";
    private static final String HEALTHCHECK_ELEM_NAME = "healthcheck";

    @Autowired
    public TroubleshootingModuleDescriptorFactory(final ModuleFactory moduleFactory, final ApplicationContext context, final ApplicationProperties applicationProperties) {
        super(new HostContainer(){

            public <T> T create(Class<T> moduleClass) throws IllegalArgumentException {
                if (SupportDataModuleDescriptor.class.isAssignableFrom(moduleClass)) {
                    return (T)new SupportDataModuleDescriptor(moduleFactory);
                }
                if (SupportHealthCheckModuleDescriptor.class.isAssignableFrom(moduleClass)) {
                    return (T)((Object)new SupportHealthCheckModuleDescriptor(moduleFactory, context, applicationProperties));
                }
                throw new RuntimeException("Cannot use this ModuleDescriptorFactory to instantiate " + moduleClass);
            }
        });
        this.addModuleDescriptor(SUPPORT_DATA_ELEM_NAME, SupportDataModuleDescriptor.class);
        this.addModuleDescriptor(HEALTHCHECK_ELEM_NAME, SupportHealthCheckModuleDescriptor.class);
    }

    public Iterable<String> getModuleDescriptorKeys() {
        return ImmutableSet.of((Object)SUPPORT_DATA_ELEM_NAME, (Object)HEALTHCHECK_ELEM_NAME);
    }

    public Set<Class<? extends ModuleDescriptor>> getModuleDescriptorClasses() {
        return ImmutableSet.of(SupportDataModuleDescriptor.class, SupportHealthCheckModuleDescriptor.class);
    }
}

