/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.mail;

import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.AbstractSupportMailQueueItem;
import com.atlassian.troubleshooting.stp.salext.mail.MailQueueItemFactory;
import com.atlassian.troubleshooting.stp.salext.mail.MailServerManagerProvider;
import com.atlassian.troubleshooting.stp.salext.mail.MailUtility;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.spi.SupportDataDetail;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;

public abstract class AbstractMailUtility
implements MailUtility {
    private static final String PRIORITY_HEADER = "X-Support-Request-Priority";
    private static final String SUPPORT_REQUEST_PROPERTIES_SUFFIX = "-support-request.properties";
    private static final String REQUEST_HEADER_SUFFIX = "-Support-Request-Version";
    private final MailQueueItemFactory mailQueueItemFactory;
    private final MailServerManagerProvider mailServerManagerProvider;

    public AbstractMailUtility(@Nonnull MailQueueItemFactory mailQueueItemFactory, @Nonnull MailServerManagerProvider mailServerManagerProvider) {
        this.mailQueueItemFactory = Objects.requireNonNull(mailQueueItemFactory);
        this.mailServerManagerProvider = Objects.requireNonNull(mailServerManagerProvider);
    }

    protected MailQueueItemFactory getMailQueueItemFactory() {
        return this.mailQueueItemFactory;
    }

    protected MailServerManagerProvider getMailFactoryProvider() {
        return this.mailServerManagerProvider;
    }

    @Override
    public String getDefaultFromAddress() {
        return Optional.ofNullable(this.mailServerManagerProvider.getDefaultSMTPMailServer()).map(SMTPMailServer::getDefaultFrom).orElse("noreply@atlassian.com");
    }

    @Override
    public void sendSupportRequestMail(SupportRequest supportRequest, SupportApplicationInfo info) throws MessagingException, MailException, IOException {
        String propertiesFileName = info.getApplicationName() + SUPPORT_REQUEST_PROPERTIES_SUFFIX;
        String requestVersionHeader = "X-" + info.getApplicationName() + REQUEST_HEADER_SUFFIX;
        String requestVersionNumber = "4.0";
        supportRequest.addHeader(PRIORITY_HEADER, String.valueOf(supportRequest.getPriority()));
        supportRequest.addHeader(requestVersionHeader, "4.0");
        supportRequest.addAttachment(this.mailQueueItemFactory.newAttachment(propertiesFileName, "text/xml", info.saveProperties(SupportDataDetail.FULL)));
        supportRequest.addAttachment(this.mailQueueItemFactory.newAttachment("support-request-details.properties", "text/plain", supportRequest.saveForMail(info)));
        this.sendSupportRequestEmail(supportRequest, info);
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailServerManagerProvider.getDefaultSMTPMailServer() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.mailServerManagerProvider.getServerManager() != null) {
                Thread.currentThread().setContextClassLoader(this.mailServerManagerProvider.getServerManager().getClass().getClassLoader());
            }
            AbstractSupportMailQueueItem item = this.mailQueueItemFactory.newSupportRequestMailQueueItem(requestInfo, info);
            item.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

