/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.zip;

import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public class SupportZipRequest
implements Serializable {
    private static final long serialVersionUID = -2556329491065171726L;
    private final boolean limitFileSizes;
    private Set<String> items;
    private final Set<String> nodeIds;
    private final Source source;
    private final String clusterTaskId;

    @JsonCreator
    public SupportZipRequest(@JsonProperty(value="items") @Nullable Set<String> items, @JsonProperty(value="limitFileSizes") @Nullable Boolean limitFileSizes, @JsonProperty(value="clusterTaskId") @Nullable String clusterTaskId, @JsonProperty(value="nodeIds") @Nullable Collection<String> nodeIds, @JsonProperty(value="source") @Nullable Source source) {
        this.items = items == null ? null : new HashSet<String>(items);
        this.limitFileSizes = limitFileSizes == null ? true : limitFileSizes;
        this.clusterTaskId = clusterTaskId;
        this.nodeIds = nodeIds == null ? null : ImmutableSet.copyOf(nodeIds);
        this.source = source;
    }

    @Nonnull
    public static SupportZipRequest withDefaultSettings(SupportApplicationInfo applicationInfo, Source source) {
        return new SupportZipRequest(SupportZipRequest.getDefaultItems(applicationInfo), true, null, null, source);
    }

    @Nonnull
    public SupportZipRequest forCluster() {
        return new SupportZipRequest(this.items, this.limitFileSizes, UUID.randomUUID().toString(), this.nodeIds, this.source);
    }

    @Nonnull
    public SupportZipRequest withSource(Source source) {
        return new SupportZipRequest(this.items, this.limitFileSizes, this.clusterTaskId, this.nodeIds, source);
    }

    @Nonnull
    public Set<String> getItems() {
        return this.items;
    }

    public boolean isLimitFileSizes() {
        return this.limitFileSizes;
    }

    @Nullable
    public String getClusterTaskId() {
        return this.clusterTaskId;
    }

    public boolean appliesToNode(String nodeId) {
        return this.nodeIds == null || this.nodeIds.contains(nodeId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Nullable
    public Set<String> getNodeIds() {
        return this.nodeIds;
    }

    public boolean appliesToNoNodes() {
        return this.nodeIds != null && this.nodeIds.isEmpty();
    }

    @Nullable
    public Source getSource() {
        return this.source;
    }

    public void useDefaultItems(SupportApplicationInfo applicationInfo) {
        this.items = SupportZipRequest.getDefaultItems(applicationInfo);
    }

    private static Set<String> getDefaultItems(SupportApplicationInfo applicationInfo) {
        return applicationInfo.getSupportZipBundles().stream().filter(SupportZipBundle::isSelected).map(SupportZipBundle::getKey).collect(Collectors.toSet());
    }

    public static enum Source {
        REST_V1("rest-v1"),
        WEB_V1("web-v1"),
        WEB_V2("web-v2");

        private final String key;

        private Source(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

