/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.request;

import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SupportZipCreationRequest {
    private final List<SupportZipBundle> bundles;
    private final boolean checkPermissions;
    private final boolean limitFileSizes;
    private final String clusterTaskId;

    SupportZipCreationRequest(Builder builder) {
        this.bundles = builder.bundles.build();
        this.checkPermissions = builder.checkPermissions;
        this.limitFileSizes = builder.limitFileSizes;
        this.clusterTaskId = builder.clusterTaskId;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public List<SupportZipBundle> getBundles() {
        return this.bundles;
    }

    public Optional<Integer> getMaxBytesPerFile() {
        if (this.limitFileSizes) {
            return Optional.of(0x1900000);
        }
        return Optional.empty();
    }

    public String getClusterTaskId() {
        return this.clusterTaskId;
    }

    public boolean isCheckPermissions() {
        return this.checkPermissions;
    }

    public int getBundleProgressShare() {
        if (this.bundles.isEmpty()) {
            return 0;
        }
        return 100 / this.bundles.size();
    }

    public static class Builder {
        private final ImmutableList.Builder<SupportZipBundle> bundles = ImmutableList.builder();
        private boolean checkPermissions = true;
        private boolean limitFileSizes;
        private String clusterTaskId;

        @Nonnull
        public Builder skipPermissionCheck() {
            this.checkPermissions = false;
            return this;
        }

        @Nonnull
        public Builder bundles(@Nonnull SupportZipBundle bundle, SupportZipBundle ... moreBundles) {
            this.bundles.add((Object)Objects.requireNonNull(bundle));
            this.bundles.addAll((Iterator)Iterators.forArray((Object[])moreBundles));
            return this;
        }

        @Nonnull
        public Builder bundles(@Nonnull Iterable<SupportZipBundle> values) {
            this.bundles.addAll(Objects.requireNonNull(values));
            return this;
        }

        @Nonnull
        public Builder limitFileSizes(boolean value) {
            this.limitFileSizes = value;
            return this;
        }

        @Nonnull
        public Builder withClusterTaskId(@Nullable String value) {
            this.clusterTaskId = value;
            return this;
        }

        @Nonnull
        public Builder limitFileSizes() {
            return this.limitFileSizes(true);
        }

        @Nonnull
        public SupportZipCreationRequest build() {
            return new SupportZipCreationRequest(this);
        }
    }
}

