/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.spi;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckCondition;
import com.atlassian.troubleshooting.healthcheck.conditions.MinimumApplicationVersionCondition;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SupportHealthCheckModuleDescriptor
extends AbstractModuleDescriptor<SupportHealthCheck> {
    private static final Logger LOG = LoggerFactory.getLogger(SupportHealthCheckModuleDescriptor.class);
    private static final int DEFAULT_TIMEOUT_MILLIS = Integer.getInteger("atlassian.healthcheck.timeout-ms", (int)TimeUnit.SECONDS.toMillis(20L));
    private static final int MAX_TIMEOUT_MILLIS = Integer.getInteger("atlassian.healthcheck.max-timeout-ms", (int)TimeUnit.SECONDS.toMillis(120L));
    private final List<SupportHealthCheckCondition> conditions = new ArrayList<SupportHealthCheckCondition>();
    private final ApplicationContext context;
    private final ApplicationProperties applicationProperties;
    private int timeOut;
    private String tag;
    private String helpPathKey;
    private String className;

    public SupportHealthCheckModuleDescriptor(ModuleFactory moduleFactory, ApplicationContext context, ApplicationProperties applicationProperties) {
        super(moduleFactory);
        this.context = context;
        this.applicationProperties = applicationProperties;
    }

    public SupportHealthCheck getModule() {
        return (SupportHealthCheck)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.initializeTimeout(element);
        this.initializeSupportedProductVersions(element);
        this.tag = element.attributeValue("tag");
        this.helpPathKey = element.attributeValue("help-path");
        this.className = element.attributeValue("class");
        List conditionElements = element.elements("condition");
        for (Element condition : conditionElements) {
            try {
                this.conditions.add(this.parseCondition(condition));
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Could not parse health check condition.", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public void initializeSupportedProductVersions(@NotNull Element element) {
        String minimumVersionString = element.attributeValue("application-minimum-version");
        if (minimumVersionString != null) {
            this.conditions.add(new MinimumApplicationVersionCondition(this.applicationProperties, minimumVersionString));
        }
    }

    private SupportHealthCheckCondition parseCondition(Element condition) throws ClassNotFoundException {
        String className = condition.attribute("class").getValue();
        return (SupportHealthCheckCondition)this.context.getBean(this.plugin.loadClass(className, this.plugin.getClass()));
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public String getHelpPathKey() {
        return this.helpPathKey;
    }

    public String getClassName() {
        return this.className;
    }

    private void initializeTimeout(Element element) {
        String timeoutString = element.attributeValue("time-out");
        if (timeoutString == null) {
            this.timeOut = DEFAULT_TIMEOUT_MILLIS;
        } else {
            try {
                int customTimeOut = Integer.parseInt(timeoutString);
                if (customTimeOut > MAX_TIMEOUT_MILLIS) {
                    this.timeOut = MAX_TIMEOUT_MILLIS;
                    LOG.warn("Custom timeout of {} ms exceeds maximum timeout of {} ms, timeout is now set to max timeout", (Object)customTimeOut, (Object)MAX_TIMEOUT_MILLIS);
                } else {
                    this.timeOut = customTimeOut;
                }
            }
            catch (NumberFormatException exception) {
                this.timeOut = DEFAULT_TIMEOUT_MILLIS;
                LOG.warn("Error parsing custom timeout, timeout is now set to a default of {} ms", (Object)DEFAULT_TIMEOUT_MILLIS);
            }
        }
    }

    public String getTag() {
        return this.tag;
    }

    public List<SupportHealthCheckCondition> getConditions() {
        return this.conditions;
    }
}

