/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.thready.manager;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.api.ClusterMessagingService;
import com.atlassian.troubleshooting.api.ListenerRegistration;
import com.atlassian.troubleshooting.cluster.JsonSerialiser;
import com.atlassian.troubleshooting.thready.manager.ConfigurationPersistenceService;
import com.atlassian.troubleshooting.thready.manager.ThreadDiagnosticsConfigurationManager;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultThreadDiagnosticsConfigurationManager
implements ThreadDiagnosticsConfigurationManager,
LifecycleAware {
    public static final String CHANNEL_NAME = "thread_diag_config";
    private final ClusterMessagingService clusterMessagingService;
    private final JsonSerialiser jsonSerialiser;
    private final ConfigurationPersistenceService configurationPersistenceService;
    private final EventPublisher eventPublisher;
    private ThreadDiagnosticsConfigurationManager.Configuration configuration;
    private ListenerRegistration listenerRegistration;

    @Autowired
    public DefaultThreadDiagnosticsConfigurationManager(ClusterMessagingService clusterMessagingService, JsonSerialiser jsonSerialiser, ConfigurationPersistenceService configurationPersistenceService, EventPublisher eventPublisher) {
        this.clusterMessagingService = Objects.requireNonNull(clusterMessagingService);
        this.jsonSerialiser = Objects.requireNonNull(jsonSerialiser);
        this.configurationPersistenceService = Objects.requireNonNull(configurationPersistenceService);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @Override
    public ThreadDiagnosticsConfigurationManager.Configuration getConfiguration() {
        return this.configuration;
    }

    public void onStart() {
        this.configuration = this.configurationPersistenceService.findConfiguration().orElseGet(() -> this.configurationPersistenceService.storeConfiguration(new ThreadDiagnosticsConfigurationManager.Configuration(false)));
        this.listenerRegistration = this.clusterMessagingService.registerListener(CHANNEL_NAME, message -> {
            this.configuration = this.jsonSerialiser.fromJson((String)message, ThreadDiagnosticsConfigurationManager.Configuration.class);
        });
    }

    public void onStop() {
        this.listenerRegistration.unregister();
    }

    @Override
    public void setConfiguration(ThreadDiagnosticsConfigurationManager.Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.configurationPersistenceService.storeConfiguration(configuration);
        this.clusterMessagingService.sendMessage(CHANNEL_NAME, this.jsonSerialiser.toJson(configuration));
        this.eventPublisher.publish((Object)new ThreadDiagnosticsConfigurationEvent(configuration));
    }

    @Override
    public boolean isThreadNameAttributesEnabled() {
        return this.getConfiguration() != null && this.getConfiguration().isEnabled();
    }

    @EventName(value="troubleshooting.threaddiagnostics.config.change")
    public static class ThreadDiagnosticsConfigurationEvent {
        private final boolean enabled;

        public ThreadDiagnosticsConfigurationEvent(ThreadDiagnosticsConfigurationManager.Configuration configuration) {
            this.enabled = configuration.isEnabled();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

