/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.jfr.service;

import com.atlassian.troubleshooting.jfr.config.JfrProperties;
import com.atlassian.troubleshooting.jfr.enums.JfrEvent;
import com.atlassian.troubleshooting.jfr.exception.JfrException;
import com.atlassian.troubleshooting.jfr.service.JfrEventExtractorService;
import com.atlassian.troubleshooting.jfr.util.JfrRecordingUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultJfrEventExtractorService
implements JfrEventExtractorService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJfrEventExtractorService.class);
    private static final String RESULT_FIELD_NAME = "result";
    private static final String THREAD_DUMP_EXT = ".txt";
    private final JfrProperties jfrProperties;

    @Autowired
    public DefaultJfrEventExtractorService(JfrProperties jfrProperties) {
        this.jfrProperties = jfrProperties;
    }

    @Override
    public Path extractThreadDumps(Path pathToJfrDump) {
        Objects.requireNonNull(pathToJfrDump);
        Path threadDumpsDir = Paths.get(FilenameUtils.removeExtension((String)pathToJfrDump.toString()), this.jfrProperties.getThreadDumpPath());
        List<RecordedEvent> threadDumpEvents = this.getRecordedEventsFromJfrDump(pathToJfrDump, event -> JfrEvent.THREAD_DUMP.getName().equals(event.getEventType().getName()));
        try {
            Files.createDirectories(threadDumpsDir, new FileAttribute[0]);
            for (RecordedEvent threadDumpEvent : threadDumpEvents) {
                if (!threadDumpEvent.hasField(RESULT_FIELD_NAME)) continue;
                this.writeToFile(threadDumpEvent.getString(RESULT_FIELD_NAME), threadDumpsDir.toString(), JfrRecordingUtils.DATE_TIME_FORMAT.format(threadDumpEvent.getStartTime()) + THREAD_DUMP_EXT);
            }
            LOG.debug("Thread dumps from JFR bundle are extracted successfully. Path: {}", (Object)threadDumpsDir);
            return threadDumpsDir;
        }
        catch (IOException exception) {
            throw new JfrException("Error extracting thread dumps", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<RecordedEvent> getRecordedEventsFromJfrDump(Path pathToRecording, Predicate<RecordedEvent> filter) {
        LinkedList<RecordedEvent> recordedEvents = new LinkedList<RecordedEvent>();
        try (RecordingFile recordingFile = new RecordingFile(pathToRecording);){
            while (recordingFile.hasMoreEvents()) {
                RecordedEvent recordedEvent = recordingFile.readEvent();
                if (!filter.test(recordedEvent)) continue;
                recordedEvents.add(recordedEvent);
            }
            LinkedList<RecordedEvent> linkedList = recordedEvents;
            return linkedList;
        }
        catch (IOException exception) {
            throw new JfrException("Error reading events from JFR recording", exception);
        }
    }

    private void writeToFile(String fileContent, String directory, String fileName) throws IOException {
        Path pathToFile = Paths.get(directory, fileName);
        if (Files.notExists(pathToFile, new LinkOption[0])) {
            Files.createFile(pathToFile, new FileAttribute[0]);
        }
        try (BufferedWriter fileWriter = Files.newBufferedWriter(pathToFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            fileWriter.write(fileContent);
        }
    }
}

