/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.servlet;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.tunnel.security.PermissionEnforcer;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import lombok.Generated;

@SystemAdminOnly
public class TunnelClientServlet
extends HttpServlet {
    static final String RESOURCE_KEY = "com.atlassian.securetunnel.client.tunnel-client-plugin:tunnel-client-soy-resources";
    static final String TEMPLATE_KEY = "tunnel.client.admin";
    static final String CLOUD_INITIATED = "cloudInitiated";
    static final String GENERATE_HEADER = "generateHeader";
    private static final String URL = "/plugins/servlet/secureconnectivity";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final RedirectsLoopPreventer loopPreventer;
    private final WebSudoManager webSudoManager;
    private final PermissionEnforcer permissionEnforcer;
    private final ApplicationProperties applicationProperties;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            this.permissionEnforcer.enforceSystemAdmin();
            this.renderTemplate(request, response);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (AuthorisationException e) {
            this.redirectToLogin(request, response);
        }
    }

    private void renderTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, (Map)ImmutableMap.of((Object)CLOUD_INITIATED, (Object)this.hasCloudInitiatedQueryParameter(request), (Object)GENERATE_HEADER, (Object)this.isNotConfluence()));
    }

    private boolean hasCloudInitiatedQueryParameter(HttpServletRequest request) {
        return request.getParameter(CLOUD_INITIATED) != null;
    }

    private boolean isNotConfluence() {
        return !"conf".equals(this.applicationProperties.getPlatformId());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String target = this.loginUriProvider.getLoginUriForRole(URI.create(URL), UserRole.SYSADMIN).toString();
        this.loopPreventer.preventRedirectsLoop(request, target);
        response.sendRedirect(target);
    }

    @Generated
    public TunnelClientServlet(SoyTemplateRenderer soyTemplateRenderer, LoginUriProvider loginUriProvider, RedirectsLoopPreventer loopPreventer, WebSudoManager webSudoManager, PermissionEnforcer permissionEnforcer, ApplicationProperties applicationProperties) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.loopPreventer = loopPreventer;
        this.webSudoManager = webSudoManager;
        this.permissionEnforcer = permissionEnforcer;
        this.applicationProperties = applicationProperties;
    }
}

